/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia.client;

import com.xiangcao.xiangcaomengjia.client.SellingBinConfigScreen;
import com.xiangcao.xiangcaomengjia.config.SellingBinConfigClient;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemPickerScreen
extends Screen {
    private final SellingBinConfigScreen parent;
    private final Set<String> alreadyAddedIds;
    private EditBox searchBox;
    private final List<ItemEntry> allItems = new ArrayList<ItemEntry>();
    private List<ItemEntry> filtered = new ArrayList<ItemEntry>();
    private int scrollOffset;
    private static final int COLS = 10;
    private static final int ROWS = 11;
    private static final int SLOT = 26;
    private static final int PAD = 14;
    private static final int TITLE_H = 20;
    private static final int SEARCH_H = 22;
    private static final int HEADER_H = 70;
    private static final int GRID_W = 260;
    private static final int GRID_H = 286;
    private static final int PANEL_W = 288;
    private static final int PANEL_H = 384;
    private static final int PANEL_BG = -14013643;
    private static final int PANEL_BORDER = -12763318;
    private static final int SLOT_BG = -14803162;
    private static final int SLOT_HOVER = -13223862;
    private int panelLeft;
    private int panelTop;

    public ItemPickerScreen(SellingBinConfigScreen parent, Set<String> alreadyAddedIds) {
        super((Component)Component.m_237115_((String)"gui.xiangcaomengjia.config.pick_item"));
        this.parent = parent;
        this.alreadyAddedIds = alreadyAddedIds != null ? alreadyAddedIds : Set.of();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ResourceLocation id;
            if (item == Items.f_41852_ || (id = ForgeRegistries.ITEMS.getKey((Object)item)) == null) continue;
            this.allItems.add(new ItemEntry(id.toString(), new ItemStack((ItemLike)item)));
        }
        this.allItems.sort(Comparator.comparing(e -> e.stack.m_41786_().getString()));
        this.filtered.addAll(this.allItems);
    }

    private void filter(String s) {
        String lower = s.toLowerCase(Locale.ROOT).trim();
        this.filtered = lower.isEmpty() ? new ArrayList<ItemEntry>(this.allItems) : this.allItems.stream().filter((? super T e) -> e.itemId.toLowerCase(Locale.ROOT).contains(lower) || e.stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains(lower)).collect(Collectors.toList());
        this.scrollOffset = 0;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.panelLeft = (this.f_96543_ - 288) / 2;
        this.panelTop = (this.f_96544_ - 384) / 2;
        int searchY = this.panelTop + 20 + 14;
        this.searchBox = new EditBox(this.f_96547_, this.panelLeft + 14, searchY, 260, 22, (Component)Component.m_237113_((String)"search"));
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"gui.xiangcaomengjia.config.search_hint"));
        this.searchBox.m_94151_(this::filter);
        this.searchBox.m_94199_(64);
        this.m_142416_((GuiEventListener)this.searchBox);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int gridLeft = this.panelLeft + 14;
        int gridTop = this.panelTop + 70;
        if (mouseX >= (double)gridLeft && mouseX < (double)(gridLeft + 260) && mouseY >= (double)gridTop && mouseY < (double)(gridTop + 286)) {
            int maxScroll = Math.max(0, (this.filtered.size() + 10 - 1) / 10 - 11);
            this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)delta));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        int gridLeft = this.panelLeft + 14;
        int gridTop = this.panelTop + 70;
        for (int row = 0; row < 11; ++row) {
            int idx;
            for (int col = 0; col < 10 && (idx = (this.scrollOffset + row) * 10 + col) < this.filtered.size(); ++col) {
                ItemEntry e = this.filtered.get(idx);
                int x = gridLeft + col * 26;
                int y = gridTop + row * 26;
                if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 26)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 26))) continue;
                if (this.alreadyAddedIds.contains(e.itemId)) {
                    List<SellingBinConfigClient.TradeEntry> list = SellingBinConfigClient.getTradeList();
                    SellingBinConfigClient.TradeEntry entry = list.stream().filter((? super T t) -> t.itemId().equals(e.itemId)).findFirst().orElse(null);
                    if (entry != null) {
                        this.parent.openEditEntry(e.itemId, entry.count(), entry.price());
                    }
                } else {
                    this.parent.onPickedItem(e.itemId);
                }
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int px = this.panelLeft;
        int py = this.panelTop;
        graphics.m_280509_(px, py, px + 288, py + 384, -14013643);
        graphics.m_280509_(px, py, px + 288, py + 1, -12763318);
        graphics.m_280509_(px, py + 384 - 1, px + 288, py + 384, -12763318);
        graphics.m_280509_(px, py, px + 1, py + 384, -12763318);
        graphics.m_280509_(px + 288 - 1, py, px + 288, py + 384, -12763318);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, py + 6, 0xF0F0F0);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int gridLeft = px + 14;
        int gridTop = py + 70;
        String hoveredTooltip = null;
        for (int row = 0; row < 11; ++row) {
            int idx;
            for (int col = 0; col < 10 && (idx = (this.scrollOffset + row) * 10 + col) < this.filtered.size(); ++col) {
                ItemEntry e = this.filtered.get(idx);
                int x = gridLeft + col * 26;
                int y = gridTop + row * 26;
                boolean hover = mouseX >= x && mouseX < x + 26 && mouseY >= y && mouseY < y + 26;
                boolean added = this.alreadyAddedIds.contains(e.itemId);
                int slotBg = added ? -870152158 : (hover ? -13223862 : -14803162);
                graphics.m_280509_(x + 1, y + 1, x + 26 - 1, y + 26 - 1, slotBg);
                graphics.m_280480_(e.stack, x + 5, y + 5);
                graphics.m_280370_(this.f_96547_, e.stack, x + 5, y + 5);
                if (!hover) continue;
                hoveredTooltip = e.itemId;
            }
        }
        if (hoveredTooltip != null) {
            String tip = hoveredTooltip;
            ItemEntry e = this.filtered.stream().filter((? super T i) -> i.itemId.equals(tip)).findFirst().orElse(null);
            if (e != null) {
                graphics.m_280153_(this.f_96547_, e.stack, mouseX, mouseY);
                if (this.alreadyAddedIds.contains(e.itemId)) {
                    graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.xiangcaomengjia.config.click_to_edit").getString(), mouseX + 12, mouseY + 4, 0xA0A0A0, false);
                }
            }
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    private static class ItemEntry {
        final String itemId;
        final ItemStack stack;

        ItemEntry(String itemId, ItemStack stack) {
            this.itemId = itemId;
            this.stack = stack;
        }
    }
}

